USE [V5_Registry]
GO
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [MSSR].[MSSR_CURRENT_STATUS](
	[PatientSID] [int] NULL,
	[PatientICN] [int] NOT NULL,
	[BaselineAssessDate] [datetime] NULL,
	[LastSymptomYear] [int] NULL,
	[URFTemplateID] [int] NULL,
	[Sta3n] [int] NULL,
	[LastAssessDate] [datetime] NULL,
	[LastAssessType] [varchar](8) NULL,
	[LastMSSubType] [varchar](10) NULL,
	[LastRelapses] [int] NULL,
	[LastEdumsScore] [varchar](2) NULL,
	[PreviousEdmusScore] [varchar](2) NULL,
	[PreviousEdmusDate] [datetime] NULL,
	[Rx1] [varchar](100) NULL,
	[Rx2] [varchar](100) NULL,
	[Rx3] [varchar](100) NULL,
	[RxAll] [varchar](max) NULL,
	[MSDiagnosis] [varchar](11) NULL,
	[RxEver1] [varchar](100) NULL,
	[RxEver2] [varchar](100) NULL,
	[RxEver3] [varchar](100) NULL,
	[RxEver4] [varchar](100) NULL,
	[RxEver5] [varchar](100) NULL,
	[RxEverAll] [varchar](max) NULL,
 CONSTRAINT [PK_MSSR_CURRENT_STATUS] PRIMARY KEY CLUSTERED 
(
	[PatientICN] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_HF_Condensed](
	[HF_Condensed_ID] [int] IDENTITY(1,1) NOT NULL,
	[PatientSID] [int] NULL,
	[PatientICN] [int] NOT NULL,
	[ETLBatchID] [int] NULL,
	[VistaCreateDateRd] [float] NULL,
	[Sta3n] [smallint] NOT NULL,
	[AssessmentDateTime] [datetime] NULL,
	[AssessmentType] [varchar](8) NULL,
	[CurrentDisabilityScore] [varchar](2) NULL,
	[MSDiagnosis] [varchar](11) NULL,
	[DiagnosisYear] [varchar](4) NULL,
	[SymptomYear] [varchar](4) NULL,
	[Ethnicity] [varchar](12) NULL,
	[ISXBowelBladder] [varchar](1) NULL,
	[ISXBrainstem] [varchar](1) NULL,
	[ISXCerebellar] [varchar](1) NULL,
	[ISXMotor] [varchar](1) NULL,
	[ISXNeuritis] [varchar](1) NULL,
	[ISXSensory] [varchar](1) NULL,
	[ISXSpinalCord] [varchar](1) NULL,
	[MSNMOISXBowelBladder] [varchar](1) NULL,
	[MSNMOISXBrainstem] [varchar](1) NULL,
	[MSNMOISXCerebellar] [varchar](1) NULL,
	[MSNMOISXMotor] [varchar](1) NULL,
	[MSNMOISXNeuritis] [varchar](1) NULL,
	[MSNMOISXSensory] [varchar](1) NULL,
	[MSNMOISXSpinalCord] [varchar](1) NULL,
	[MSInterview] [varchar](16) NULL,
	[MSCOEInterview] [varchar](16) NULL,
	[RaceAmerIndian] [varchar](1) NULL,
	[RaceAsian] [varchar](1) NULL,
	[RaceBlack] [varchar](1) NULL,
	[RaceOther] [varchar](1) NULL,
	[RacePI] [varchar](1) NULL,
	[RaceWhite] [varchar](1) NULL,
	[Relapses] [int] NULL,
	[MSSC] [varchar](1) NULL,
	[MSSubType] [varchar](10) NULL,
	[InterferonAntibodies] [varchar](8) NULL,
	[MedAntiJCVirus] [varchar](8) NULL,
	[MedAzathioprineNever] [varchar](1) NULL,
	[MedAzathioprineCurrentDispRx] [varchar](6) NULL,
	[MedAzathioprinePastNonVA] [varchar](1) NULL,
	[MedAzathioprinePastVA] [varchar](1) NULL,
	[MedAzathioprineStopInnefective] [varchar](1) NULL,
	[MedAzathioprineStopIntolerant] [varchar](1) NULL,
	[MedCycloPhosNever] [varchar](1) NULL,
	[MedCycloPhosCurrentDispRx] [varchar](6) NULL,
	[MedCycloPhosPastNonVA] [varchar](1) NULL,
	[MedCycloPhosPastVA] [varchar](1) NULL,
	[MedCycloPhosStopMaxDose] [varchar](1) NULL,
	[MedCycloPhosStopInnefective] [varchar](1) NULL,
	[MedCycloPhosStopIntolerant] [varchar](1) NULL,
	[MedDaclizumabNever] [varchar](1) NULL,
	[MedDaclizumabDispRx] [varchar](6) NULL,
	[MedDaclizumabNonVA] [varchar](1) NULL,
	[MedDaclizumabPastVA] [varchar](1) NULL,
	[MedDaclizumabStopInnefective] [varchar](1) NULL,
	[MedDaclizumabStopIntolerant] [varchar](1) NULL,
	[MedDaclizumabStopAbnBlood] [varchar](1) NULL,
	[MedDaclizumabStopRash] [varchar](1) NULL,
	[MedDaclizumabStopImmuno] [varchar](1) NULL,
	[MedFingolimodNever] [varchar](1) NULL,
	[MedFingolimodCurrentDispRx] [varchar](6) NULL,
	[MedFingolimodPastNonVA] [varchar](1) NULL,
	[MedFingolimodPastVA] [varchar](1) NULL,
	[MedFingolimodStopInnefective] [varchar](1) NULL,
	[MedFingolimodStopIntolerant] [varchar](1) NULL,
	[MedGlatiramerNever] [varchar](1) NULL,
	[MedGlatiramerCurrentDispRx] [varchar](6) NULL,
	[MedGlatiramerPastNonVA] [varchar](1) NULL,
	[MedGlatiramerPastVA] [varchar](1) NULL,
	[MedGlatiramerStopInnefective] [varchar](1) NULL,
	[MedGlatiramerStopIntolerant] [varchar](1) NULL,
	[MedAvonexNever] [varchar](1) NULL,
	[MedAvonexCurrentDispRx] [varchar](6) NULL,
	[MedAvonexPastNonVA] [varchar](1) NULL,
	[MedAvonexPastVA] [varchar](1) NULL,
	[MedAvonexStopInnefective] [varchar](1) NULL,
	[MedAvonexStopIntolerant] [varchar](1) NULL,
	[MedRebifNever] [varchar](1) NULL,
	[MedRebifCurrentDispRx] [varchar](6) NULL,
	[MedRebifPastNonVA] [varchar](1) NULL,
	[MedRebifPastVA] [varchar](1) NULL,
	[MedRebifStopInnefective] [varchar](1) NULL,
	[MedRebifStopIntolerant] [varchar](1) NULL,
	[MedBetaseronNever] [varchar](1) NULL,
	[MedBetaseronCurrentDispRx] [varchar](6) NULL,
	[MedBetaseronPastNonVA] [varchar](1) NULL,
	[MedBetaseronPastVA] [varchar](1) NULL,
	[MedBetaseronStopInnefective] [varchar](1) NULL,
	[MedBetaseronStopIntolerant] [varchar](1) NULL,
	[MedExtaviaNever] [varchar](1) NULL,
	[MedExtaviaCurrentDispRx] [varchar](6) NULL,
	[MedExtaviaPastNonVA] [varchar](1) NULL,
	[MedExtaviaPastVA] [varchar](1) NULL,
	[MedExtaviaStopInnefective] [varchar](1) NULL,
	[MedExtaviaStopIntolerant] [varchar](1) NULL,
	[MedMethotrexNever] [varchar](1) NULL,
	[MedMethotrexCurrentDispRx] [varchar](6) NULL,
	[MedMethotrexPastNonVA] [varchar](1) NULL,
	[MedMethotrexPastVA] [varchar](1) NULL,
	[MedMethotrexStopInnefective] [varchar](1) NULL,
	[MedMethotrexStopIntolerant] [varchar](1) NULL,
	[MedMitoxanCardioTox] [varchar](1) NULL,
	[MedMitoxanCardioToxDtUnk] [varchar](1) NULL,
	[MedMitoxanNever] [varchar](1) NULL,
	[MedMitoxanCurrentDispRxx] [varchar](6) NULL,
	[MedMitoxanPastNonVA] [varchar](1) NULL,
	[MedMitoxanPastVA] [varchar](1) NULL,
	[MedMitoxanStopMaxDose] [varchar](1) NULL,
	[MedMitoxanStopInnefective] [varchar](1) NULL,
	[MedMitoxanStopIntolerant] [varchar](1) NULL,
	[MedMycophenNever] [varchar](1) NULL,
	[MedMycophenCurrentDispRx] [varchar](6) NULL,
	[MedMycophenPastNonVA] [varchar](1) NULL,
	[MedMycophenPastVA] [varchar](1) NULL,
	[MedMycophenStopInnefective] [varchar](1) NULL,
	[MedMycophenStopIntolerant] [varchar](1) NULL,
	[MedNatalizNever] [varchar](1) NULL,
	[MedNatalizCurrentDispRx] [varchar](6) NULL,
	[MedNatalizPastNonVA] [varchar](1) NULL,
	[MedNatalizPastVA] [varchar](1) NULL,
	[MedNatalizStopInnefective] [varchar](1) NULL,
	[MedNatalizStopIntolerant] [varchar](1) NULL,
	[MedNatalizStopPosJCAB] [varchar](1) NULL,
	[MedNatalizCurrentDose] [varchar](5) NULL,
	[MedNatalizPastDose] [varchar](5) NULL,
	[MedRituximabNever] [varchar](1) NULL,
	[MedRituximabCurrentDispRx] [varchar](6) NULL,
	[MedRituximabPastNonVA] [varchar](1) NULL,
	[MedRituximabPastVA] [varchar](1) NULL,
	[MedRituximabStopTxComplete] [varchar](1) NULL,
	[MedRituximabStopInnefective] [varchar](1) NULL,
	[MedRituximabStopIntolerant] [varchar](1) NULL,
	[MedRituximabStopAbnBlood] [varchar](1) NULL,
	[MedRituximabStopRash] [varchar](1) NULL,
	[MedRituximabStopImmuno] [varchar](1) NULL,
	[MedOtherDMTNever] [varchar](1) NULL,
	[MedOtherDMTCurrentDispRx] [varchar](6) NULL,
	[MedOtherDMTPastNonVA] [varchar](1) NULL,
	[MedOtherDMTPastVA] [varchar](1) NULL,
	[MedOtherDMTStopMaxDose] [varchar](1) NULL,
	[MedOtherDMTStopInnefective] [varchar](1) NULL,
	[MedOtherDMTStopIntolerant] [varchar](1) NULL,
	[MedDexamethIVCurrentDispRx] [varchar](6) NULL,
	[MedDexamethCurrentMonthly] [varchar](1) NULL,
	[MedDexamethPastNonVA] [varchar](1) NULL,
	[MedDexamethPastVA] [varchar](1) NULL,
	[MedDexamethPastMonthly] [varchar](1) NULL,
	[MedMethylpredIVCurrentDispRx] [varchar](6) NULL,
	[MedMethylpredIVCurrentMonthly] [varchar](1) NULL,
	[MedMethylpredIVPastNonVA] [varchar](1) NULL,
	[MedMethylpredIVPastVA] [varchar](1) NULL,
	[MedMethylpredIVPastMonthly] [varchar](1) NULL,
	[MedMethylpredPOCurrentDispRx] [varchar](6) NULL,
	[MedMethylpredPOCurrentMonthly] [varchar](1) NULL,
	[MedMethylpredPOPastNonVA] [varchar](1) NULL,
	[MedMethylpredPOPastVA] [varchar](1) NULL,
	[MedMethylpredPOPastMonthly] [varchar](1) NULL,
	[MedPrednisonePOCurrentDispRx] [varchar](6) NULL,
	[MedPrednisonePOCurrentMonthly] [varchar](1) NULL,
	[MedPrednisonePOPastNonVA] [varchar](1) NULL,
	[MedPrednisonePOPastVA] [varchar](1) NULL,
	[MedPrednisonePOPastMonthly] [varchar](1) NULL,
	[URFTemplateID] [int] NOT NULL,
 CONSTRAINT [PK_MSSR_HF_Condensed] PRIMARY KEY CLUSTERED 
(
	[HF_Condensed_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_PATIENT_DEMS](
	[PatientSSN] [varchar](50) NULL,
	[PatientSID] [int] NULL,
	[PatientICN] [int] NOT NULL,
	[PatientFirstName] [varchar](50) NULL,
	[PatientLastName] [varchar](50) NULL,
	[PatientName] [varchar](100) NULL,
	[Age] [decimal](18, 0) NULL,
	[DateOfBirth] [datetime] NULL,
	[DateOfDeath] [datetime] NULL,
	[City] [varchar](50) NULL,
	[State] [varchar](30) NULL,
	[Gender] [char](1) NULL,
	[MaritalStatus] [varchar](25) NULL,
	[Religion] [varchar](30) NULL,
	[Region] [int] NOT NULL,
	[Race] [varchar](25) NULL,
	[Ethnicity] [varchar](25) NULL,
 CONSTRAINT [PK_MSSR_PATIENT_DEMS] PRIMARY KEY CLUSTERED 
(
	[PatientICN] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
CREATE TABLE [MSSR].[MSSR_PATIENT_PDX_VIEW](
	[PatientSID] [int] NOT NULL,
	[PatientIEN] [varchar](50) NOT NULL,
	[Sta3n] [smallint] NOT NULL,
	[PatientName] [varchar](100) NULL,
	[PatientLastName] [varchar](50) NULL,
	[PatientFirstName] [varchar](50) NULL,
	[PatientSSN] [varchar](50) NULL,
	[ScrSSN] [varchar](50) NULL,
	[StreetAddress1] [varchar](50) NULL,
	[StreetAddress2] [varchar](50) NULL,
	[StreetAddress3] [varchar](50) NULL,
	[City] [varchar](50) NULL,
	[Zip] [varchar](50) NULL,
	[Zip4] [varchar](50) NULL,
	[PostalCode] [varchar](50) NULL,
	[Province] [varchar](50) NULL,
	[Country] [varchar](100) NULL,
	[PhoneResidence] [varchar](50) NULL,
	[PhoneWork] [varchar](50) NULL,
	[PhoneCellular] [varchar](50) NULL,
	[MothersMaidenName] [varchar](50) NULL,
	[DateOfDeath] [datetime] NULL,
	[DateOfDeathText] [varchar](50) NULL,
	[EmailAddress] [varchar](50) NULL,
	[BadAddressIndicator] [varchar](50) NULL,
	[ExcludeFromFacilityDirectoryFlag] [char](1) NULL,
	[AddressChangeInstitutionIEN] [varchar](50) NULL,
	[AddressChangeInstitutionSID] [int] NULL,
	[AddressChangeStaffIEN] [varchar](50) NULL,
	[AddressChangeStaffSID] [int] NULL,
	[NOKPrimaryChangeDateTime] [datetime] NULL,
	[NOKSecondaryChangeDateTime] [datetime] NULL,
	[NOKRelationshipToPatient] [varchar](50) NULL,
	[NOKDesigneeSameAsFlag] [char](1) NULL,
	[NOKEmergencyContactSameAsFlag] [char](1) NULL,
	[TemporaryAddressActiveFlag] [char](1) NULL,
	[TemporaryAddressLastEditedDateTime] [datetime] NULL,
	[TemporaryAddressChangeInstitutionIEN] [varchar](50) NULL,
	[TemporaryAddressChangeInstitutionSID] [int] NULL,
	[TemporaryAddressStartDate] [datetime] NULL,
	[TemporaryAddressEndDate] [datetime] NULL,
	[ConfidentialAddressActiveFlag] [char](1) NULL,
	[CatastrophicallyDisabledFlag] [char](1) NULL,
	[CatastrophicallyDisabledDecisionDate] [datetime] NULL,
	[CatastrophicallyDisabledReviewedDate] [datetime] NULL,
	[CatastrophicallyDisabledDeterminingInstitutionIEN] [varchar](50) NULL,
	[CatastrophicallyDisabledDeterminingInstitutionSID] [int] NULL,
	[CatastrophicallyDisabledDeterminationType] [varchar](50) NULL,
	[CurrentPurpleHeartDecisionType] [varchar](50) NULL,
	[CurrentPurpleHeartStatus] [varchar](50) NULL,
	[PurpleHeartInstitutionIEN] [varchar](50) NULL,
	[PurpleHeartInstitutionSID] [int] NULL,
	[PatientICNChecksum] [varchar](50) NULL,
	[MedicaidNumber] [varchar](50) NULL,
	[Gender] [char](1) NULL,
	[Age] [decimal](18, 0) NULL,
	[StateIEN] [varchar](50) NULL,
	[StateSID] [int] NULL,
	[State] [varchar](30) NULL,
	[County] [varchar](50) NULL,
	[Deceased] [char](1) NULL,
	[PatientICN] [varchar](50) NULL,
	[PseudoSSNFlag] [char](1) NULL,
	[PeriodOfService] [varchar](50) NULL,
	[CurrentMeansTestStatusIEN] [varchar](50) NULL,
	[MaritalStatusIEN] [varchar](50) NULL,
	[MaritalStatusSID] [int] NULL,
	[MaritalStatus] [varchar](25) NULL,
	[PercentServiceConnect] [int] NULL,
	[InsuranceCoverageFlag] [char](1) NULL,
	[ReligionIEN] [varchar](50) NULL,
	[ReligionSID] [int] NULL,
	[Religion] [varchar](30) NULL,
	[AgentOrangeExposureFlag] [char](1) NULL,
	[AgentOrangeLocationCode] [char](1) NULL,
	[IonizingRadiationExposureFlag] [char](1) NULL,
	[VeteranFlag] [char](1) NULL,
	[CombatFlag] [char](1) NULL,
	[CombatEndDate] [datetime] NULL,
	[TestPatientFlag] [char](1) NULL,
	[SpinalCordInjuryType] [varchar](50) NULL,
	[ERI] [varchar](50) NULL,
	[EnteredIntoFileDate] [datetime] NULL,
	[EligibilityIEN] [varchar](50) NULL,
	[EligibilityCodeIEN] [varchar](50) NULL,
	[EligibilitySID] [int] NULL,
	[Eligibility] [varchar](50) NULL,
	[EligibilityVACode] [varchar](50) NULL,
	[DateOfBirth] [datetime] NULL,
	[DateOfBirthText] [varchar](50) NULL,
	[SensitiveFlag] [char](1) NULL,
	[LastServiceEntryDate] [datetime] NULL,
	[LastServiceSeparationDate] [datetime] NULL,
	[PreferredInstitutionIEN] [varchar](50) NULL,
	[PreferredInstitutionSID] [int] NULL,
	[POWServicePeriodIEN] [varchar](50) NULL,
	[POWLocationIEN] [varchar](50) NULL,
	[POWFlag] [char](1) NULL,
	[POWFromVistaDate] [varchar](50) NULL,
	[POWToVistaDate] [varchar](50) NULL,
	[CombatServicePeriodIEN] [varchar](50) NULL,
	[CombatFromVistaDate] [varchar](50) NULL,
	[CombatToVistaDate] [varchar](50) NULL,
	[CDWPossibleTestPatientFlag] [char](1) NULL,
	[ETLBatchID] [int] NULL,
	[OpCode] [char](1) NOT NULL,
	[VistaCreateDate] [datetime] NULL,
	[VistaEditDate] [datetime] NULL
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [MSSR].[MSSR_CURRENT_STATUS]  WITH CHECK ADD  CONSTRAINT [FK_MSSR_CURRENT_STATUS_MSSR_PATIENT_DEMS] FOREIGN KEY([PatientICN])
REFERENCES [MSSR].[MSSR_PATIENT_DEMS] ([PatientICN])
GO

ALTER TABLE [MSSR].[MSSR_CURRENT_STATUS] CHECK CONSTRAINT [FK_MSSR_CURRENT_STATUS_MSSR_PATIENT_DEMS]
GO

ALTER TABLE [MSSR].[MSSR_HF_Condensed]  WITH CHECK ADD  CONSTRAINT [FK_MSSR_HF_Condensed_MSSR_PATIENT_DEMS] FOREIGN KEY([PatientICN])
REFERENCES [MSSR].[MSSR_PATIENT_DEMS] ([PatientICN])
GO

ALTER TABLE [MSSR].[MSSR_HF_Condensed] CHECK CONSTRAINT [FK_MSSR_HF_Condensed_MSSR_PATIENT_DEMS]
GO


